package org.kodein.emoji.objects.other_object

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _IdentificationCard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪪",
        description = "identification card",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("identification-card", "id"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: other-object: identification card.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.IdentificationCard: Emoji get() = _IdentificationCard

/**
 * Alias to emoji [IdentificationCard] (Objects: other-object: identification card).
*/
public val Emoji.Companion.Id: Emoji get() = _IdentificationCard
