package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonFrowning: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙍",
        description = "person frowning",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-frowning", "frowning"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person frowning.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonFrowning: SkinTone1Emoji get() = _PersonFrowning

/**
 * Alias to emoji [PersonFrowning] (People & Body: person-gesture: person frowning).
*/
public val Emoji.Companion.Frowning: SkinTone1Emoji get() = _PersonFrowning
