package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CatWithTearsOfJoy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😹",
        description = "cat with tears of joy",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cat-with-tears-of-joy", "joy-cat"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: cat with tears of joy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CatWithTearsOfJoy: Emoji get() = _CatWithTearsOfJoy

/**
 * Alias to emoji [CatWithTearsOfJoy] (Smileys & Emotion: cat-face: cat with tears of joy).
*/
public val Emoji.Companion.JoyCat: Emoji get() = _CatWithTearsOfJoy
