package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AnxiousFaceWithSweat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😰",
        description = "anxious face with sweat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("anxious-face-with-sweat", "anxious-with-sweat"),
        emoticons = listOf("D-':"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: anxious face with sweat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AnxiousFaceWithSweat: Emoji get() = _AnxiousFaceWithSweat

/**
 * Alias to emoji [AnxiousFaceWithSweat] (Smileys & Emotion: face-concerned: anxious face with sweat).
*/
public val Emoji.Companion.AnxiousWithSweat: Emoji get() = _AnxiousFaceWithSweat
