package org.kodein.emoji.symbols.gender

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllGender() {
    add(intArrayOf(0x2640, 0xfe0f), _FemaleSign)
    add(intArrayOf(0x2640), _FemaleSign)
    add(intArrayOf(0x2642, 0xfe0f), _MaleSign)
    add(intArrayOf(0x2642), _MaleSign)
    add(intArrayOf(0x26a7, 0xfe0f), _TransgenderSymbol)
    add(intArrayOf(0x26a7), _TransgenderSymbol)
}

internal fun MutableList<Emoji>.addAllGender() {
    add(_FemaleSign)
    add(_MaleSign)
    add(_TransgenderSymbol)
}

/**
 * All Emoji of the Symbols: gender subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allGender(): List<Emoji> =
    ArrayList<Emoji>(3).apply { addAllGender() }
