package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Divide: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "➗",
        description = "divide",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("divide", "division-sign"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: math: divide.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Divide: Emoji get() = _Divide

/**
 * Alias to emoji [Divide] (Symbols: math: divide).
*/
public val Emoji.Companion.DivisionSign: Emoji get() = _Divide
