package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WaterPistol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔫",
        description = "water pistol",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("water-pistol", "pistol"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: game: water pistol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WaterPistol: Emoji get() = _WaterPistol

/**
 * Alias to emoji [WaterPistol] (Activities: game: water pistol).
*/
public val Emoji.Companion.Pistol: Emoji get() = _WaterPistol
