package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPhilippines: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇭",
        description = "flag: Philippines",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-philippines", "philippines-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Philippines.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPhilippines: Emoji get() = _FlagPhilippines

/**
 * Alias to emoji [FlagPhilippines] (Flags: country-flag: flag: Philippines).
*/
public val Emoji.Companion.PhilippinesFlag: Emoji get() = _FlagPhilippines
