package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PageWithCurl: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📃",
        description = "page with curl",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("page-with-curl", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: book-paper: page with curl.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PageWithCurl: Emoji get() = _PageWithCurl
