package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LowBattery: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪫",
        description = "low battery",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("low-battery", "battery-low"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Objects: computer: low battery.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LowBattery: Emoji get() = _LowBattery

/**
 * Alias to emoji [LowBattery] (Objects: computer: low battery).
*/
public val Emoji.Companion.BatteryLow: Emoji get() = _LowBattery
