package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EnvelopeWithArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📩",
        description = "envelope with arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("envelope-with-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: mail: envelope with arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EnvelopeWithArrow: Emoji get() = _EnvelopeWithArrow
