package org.kodein.emoji.objects.musical_instrument

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LongDrum: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪘",
        description = "long drum",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("long-drum", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: musical-instrument: long drum.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LongDrum: Emoji get() = _LongDrum
