package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteCane: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦯",
        description = "white cane",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("white-cane", "probing-cane"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: white cane.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteCane: Emoji get() = _WhiteCane

/**
 * Alias to emoji [WhiteCane] (Objects: tool: white cane).
*/
public val Emoji.Companion.ProbingCane: Emoji get() = _WhiteCane
