package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyWomanWomanBoy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👩‍👩‍👦",
        description = "family: woman, woman, boy",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("family-woman-woman-boy", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji People & Body: family: family: woman, woman, boy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyWomanWomanBoy: Emoji get() = _FamilyWomanWomanBoy
