package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _ManDancing: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🕺",
        description = "man dancing",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("man-dancing", "dancer-man"),
        emoticons = listOf("♪┗(･o･)┓♪"),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: man dancing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ManDancing: SkinTone1Emoji get() = _ManDancing

/**
 * Alias to emoji [ManDancing] (People & Body: person-activity: man dancing).
*/
public val Emoji.Companion.DancerMan: SkinTone1Emoji get() = _ManDancing
