package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PersonFencing: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤺",
        description = "person fencing",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("person-fencing", "fencing"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji People & Body: person-sport: person fencing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonFencing: Emoji get() = _PersonFencing

/**
 * Alias to emoji [PersonFencing] (People & Body: person-sport: person fencing).
*/
public val Emoji.Companion.Fencing: Emoji get() = _PersonFencing
