package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PlayOrPauseButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏯️",
        description = "play or pause button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("play-or-pause-button", "play-or-pause", "right-pointing-triangle-with-double-vertical-bar"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: play or pause button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PlayOrPauseButton: Emoji get() = _PlayOrPauseButton

/**
 * Alias to emoji [PlayOrPauseButton] (Symbols: av-symbol: play or pause button).
*/
public val Emoji.Companion.PlayOrPause: Emoji get() = _PlayOrPauseButton

/**
 * Alias to emoji [PlayOrPauseButton] (Symbols: av-symbol: play or pause button).
*/
public val Emoji.Companion.RightPointingTriangleWithDoubleVerticalBar: Emoji get() = _PlayOrPauseButton
