package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlueCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔵",
        description = "blue circle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("blue-circle", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: blue circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlueCircle: Emoji get() = _BlueCircle
