package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap3: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "3️⃣",
        description = "keycap: 3",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-3", "three", "keycap-three"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 3.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap3: Emoji get() = _Keycap3

/**
 * Alias to emoji [Keycap3] (Symbols: keycap: keycap: 3).
*/
public val Emoji.Companion.Three: Emoji get() = _Keycap3

/**
 * Alias to emoji [Keycap3] (Symbols: keycap: keycap: 3).
*/
public val Emoji.Companion.KeycapThree: Emoji get() = _Keycap3
