package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UmbrellaWithRainDrops: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☔",
        description = "umbrella with rain drops",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("umbrella-with-rain-drops", "umbrella-in-rain"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: umbrella with rain drops.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UmbrellaWithRainDrops: Emoji get() = _UmbrellaWithRainDrops

/**
 * Alias to emoji [UmbrellaWithRainDrops] (Travel & Places: sky & weather: umbrella with rain drops).
*/
public val Emoji.Companion.UmbrellaInRain: Emoji get() = _UmbrellaWithRainDrops
