package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RollerSkate: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛼",
        description = "roller skate",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("roller-skate", "roller-skates"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: roller skate.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RollerSkate: Emoji get() = _RollerSkate

/**
 * Alias to emoji [RollerSkate] (Travel & Places: transport-ground: roller skate).
*/
public val Emoji.Companion.RollerSkates: Emoji get() = _RollerSkate
