package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBulgaria: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇬",
        description = "flag: Bulgaria",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bulgaria", "bulgaria-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bulgaria.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBulgaria: Emoji get() = _FlagBulgaria

/**
 * Alias to emoji [FlagBulgaria] (Flags: country-flag: flag: Bulgaria).
*/
public val Emoji.Companion.BulgariaFlag: Emoji get() = _FlagBulgaria
