package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPortugal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇹",
        description = "flag: Portugal",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-portugal", "portugal-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Portugal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPortugal: Emoji get() = _FlagPortugal

/**
 * Alias to emoji [FlagPortugal] (Flags: country-flag: flag: Portugal).
*/
public val Emoji.Companion.PortugalFlag: Emoji get() = _FlagPortugal
