package org.kodein.emoji.food_drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.food_drink.food_fruit.*
import org.kodein.emoji.food_drink.dishware.*
import org.kodein.emoji.food_drink.food_marine.*
import org.kodein.emoji.food_drink.food_sweet.*
import org.kodein.emoji.food_drink.food_vegetable.*
import org.kodein.emoji.food_drink.food_asian.*
import org.kodein.emoji.food_drink.food_prepared.*
import org.kodein.emoji.food_drink.drink.*


internal fun EmojiFinder.addAllFoodDrink() {
    addAllFoodFruit()
    addAllDishware()
    addAllFoodMarine()
    addAllFoodSweet()
    addAllFoodVegetable()
    addAllFoodAsian()
    addAllFoodPrepared()
    addAllDrink()
}

internal fun MutableList<Emoji>.addAllFoodDrink() {
    addAllFoodFruit()
    addAllDishware()
    addAllFoodMarine()
    addAllFoodSweet()
    addAllFoodVegetable()
    addAllFoodAsian()
    addAllFoodPrepared()
    addAllDrink()
}

/**
 * All Emoji of the Food & Drink group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFoodDrink(): List<Emoji> =
    ArrayList<Emoji>(135).apply { addAllFoodDrink() }

internal fun allFoodDrinkSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "food_fruit" to { Emoji.allFoodFruit() },
        "dishware" to { Emoji.allDishware() },
        "food_marine" to { Emoji.allFoodMarine() },
        "food_sweet" to { Emoji.allFoodSweet() },
        "food_vegetable" to { Emoji.allFoodVegetable() },
        "food_asian" to { Emoji.allFoodAsian() },
        "food_prepared" to { Emoji.allFoodPrepared() },
        "drink" to { Emoji.allDrink() },
    )
