package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Briefs: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩲",
        description = "briefs",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("briefs", "swim-brief"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: briefs.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Briefs: Emoji get() = _Briefs

/**
 * Alias to emoji [Briefs] (Objects: clothing: briefs).
*/
public val Emoji.Companion.SwimBrief: Emoji get() = _Briefs
