package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TopHat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎩",
        description = "top hat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("top-hat", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: top hat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TopHat: Emoji get() = _TopHat
