package org.kodein.emoji.objects.lock

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LockedWithKey: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔐",
        description = "locked with key",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("locked-with-key", "lock-with-key"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: lock: locked with key.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LockedWithKey: Emoji get() = _LockedWithKey

/**
 * Alias to emoji [LockedWithKey] (Objects: lock: locked with key).
*/
public val Emoji.Companion.LockWithKey: Emoji get() = _LockedWithKey
