package org.kodein.emoji.objects.phone

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TelephoneReceiver: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📞",
        description = "telephone receiver",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("telephone-receiver", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: phone: telephone receiver.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TelephoneReceiver: Emoji get() = _TelephoneReceiver
