package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpeakerHighVolume: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔊",
        description = "speaker high volume",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("speaker-high-volume", "high-volume"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: sound: speaker high volume.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpeakerHighVolume: Emoji get() = _SpeakerHighVolume

/**
 * Alias to emoji [SpeakerHighVolume] (Objects: sound: speaker high volume).
*/
public val Emoji.Companion.HighVolume: Emoji get() = _SpeakerHighVolume
