package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NutAndBolt: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔩",
        description = "nut and bolt",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("nut-and-bolt", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: nut and bolt.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NutAndBolt: Emoji get() = _NutAndBolt
