package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseNotFreeOfChargeButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈶",
        description = "Japanese “not free of charge” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-not-free-of-charge-button", "not-free-of-charge"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “not free of charge” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseNotFreeOfChargeButton: Emoji get() = _JapaneseNotFreeOfChargeButton

/**
 * Alias to emoji [JapaneseNotFreeOfChargeButton] (Symbols: alphanum: Japanese “not free of charge” button).
*/
public val Emoji.Companion.NotFreeOfCharge: Emoji get() = _JapaneseNotFreeOfChargeButton
