package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Plus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "➕",
        description = "plus",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("plus", "plus-sign", "-"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Symbols: math: plus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Plus: Emoji get() = _Plus

/**
 * Alias to emoji [Plus] (Symbols: math: plus).
*/
public val Emoji.Companion.PlusSign: Emoji get() = _Plus
