package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllReligion() {
    add(intArrayOf(0x269b, 0xfe0f), _AtomSymbol)
    add(intArrayOf(0x269b), _AtomSymbol)
    add(intArrayOf(0x1f6d0), _PlaceOfWorship)
    add(intArrayOf(0x1f549, 0xfe0f), _Om)
    add(intArrayOf(0x1f549), _Om)
    add(intArrayOf(0x2638, 0xfe0f), _WheelOfDharma)
    add(intArrayOf(0x2638), _WheelOfDharma)
    add(intArrayOf(0x262e, 0xfe0f), _PeaceSymbol)
    add(intArrayOf(0x262e), _PeaceSymbol)
    add(intArrayOf(0x262f, 0xfe0f), _YinYang)
    add(intArrayOf(0x262f), _YinYang)
    add(intArrayOf(0x262a, 0xfe0f), _StarAndCrescent)
    add(intArrayOf(0x262a), _StarAndCrescent)
    add(intArrayOf(0x1faaf), _Khanda)
    add(intArrayOf(0x271d, 0xfe0f), _LatinCross)
    add(intArrayOf(0x271d), _LatinCross)
    add(intArrayOf(0x2626, 0xfe0f), _OrthodoxCross)
    add(intArrayOf(0x2626), _OrthodoxCross)
    add(intArrayOf(0x2721, 0xfe0f), _StarOfDavid)
    add(intArrayOf(0x2721), _StarOfDavid)
    add(intArrayOf(0x1f52f), _DottedSixPointedStar)
    add(intArrayOf(0x1f54e), _Menorah)
}

internal fun MutableList<Emoji>.addAllReligion() {
    add(_AtomSymbol)
    add(_PlaceOfWorship)
    add(_Om)
    add(_WheelOfDharma)
    add(_PeaceSymbol)
    add(_YinYang)
    add(_StarAndCrescent)
    add(_Khanda)
    add(_LatinCross)
    add(_OrthodoxCross)
    add(_StarOfDavid)
    add(_DottedSixPointedStar)
    add(_Menorah)
}

/**
 * All Emoji of the Symbols: religion subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allReligion(): List<Emoji> =
    ArrayList<Emoji>(13).apply { addAllReligion() }
