package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCapeVerde: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇻",
        description = "flag: Cape Verde",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cape-verde", "cape-verde-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cape Verde.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCapeVerde: Emoji get() = _FlagCapeVerde

/**
 * Alias to emoji [FlagCapeVerde] (Flags: country-flag: flag: Cape Verde).
*/
public val Emoji.Companion.CapeVerdeFlag: Emoji get() = _FlagCapeVerde
