package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMalawi: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇼",
        description = "flag: Malawi",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-malawi", "malawi-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Malawi.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMalawi: Emoji get() = _FlagMalawi

/**
 * Alias to emoji [FlagMalawi] (Flags: country-flag: flag: Malawi).
*/
public val Emoji.Companion.MalawiFlag: Emoji get() = _FlagMalawi
