package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BookmarkTabs: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📑",
        description = "bookmark tabs",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bookmark-tabs", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: book-paper: bookmark tabs.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BookmarkTabs: Emoji get() = _BookmarkTabs
