package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonRowingBoat: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🚣",
        description = "person rowing boat",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("person-rowing-boat", "rowing-boat"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person rowing boat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonRowingBoat: SkinTone1Emoji get() = _PersonRowingBoat

/**
 * Alias to emoji [PersonRowingBoat] (People & Body: person-sport: person rowing boat).
*/
public val Emoji.Companion.RowingBoat: SkinTone1Emoji get() = _PersonRowingBoat
