package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ThoughtBalloon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💭",
        description = "thought balloon",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("thought-balloon", "thought-bubble"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: thought balloon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ThoughtBalloon: Emoji get() = _ThoughtBalloon

/**
 * Alias to emoji [ThoughtBalloon] (Smileys & Emotion: emotion: thought balloon).
*/
public val Emoji.Companion.ThoughtBubble: Emoji get() = _ThoughtBalloon
