package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceConcerned() {
    add(intArrayOf(0x1f62d), _LoudlyCryingFace)
    add(intArrayOf(0x1f979), _FaceHoldingBackTears)
    add(intArrayOf(0x1f97a), _PleadingFace)
    add(intArrayOf(0x1f971), _YawningFace)
    add(intArrayOf(0x1f631), _FaceScreamingInFear)
    add(intArrayOf(0x1f61e), _DisappointedFace)
    add(intArrayOf(0x1f613), _DowncastFaceWithSweat)
    add(intArrayOf(0x1f61f), _WorriedFace)
    add(intArrayOf(0x1f625), _SadButRelievedFace)
    add(intArrayOf(0x1f622), _CryingFace)
    add(intArrayOf(0x2639, 0xfe0f), _FrowningFace)
    add(intArrayOf(0x2639), _FrowningFace)
    add(intArrayOf(0x1f641), _SlightlyFrowningFace)
    add(intArrayOf(0x1fae4), _FaceWithDiagonalMouth)
    add(intArrayOf(0x1f615), _ConfusedFace)
    add(intArrayOf(0x1f630), _AnxiousFaceWithSweat)
    add(intArrayOf(0x1f628), _FearfulFace)
    add(intArrayOf(0x1f627), _AnguishedFace)
    add(intArrayOf(0x1f626), _FrowningFaceWithOpenMouth)
    add(intArrayOf(0x1f62e), _FaceWithOpenMouth)
    add(intArrayOf(0x1f62f), _HushedFace)
    add(intArrayOf(0x1f632), _AstonishedFace)
    add(intArrayOf(0x1f633), _FlushedFace)
    add(intArrayOf(0x1f616), _ConfoundedFace)
    add(intArrayOf(0x1f623), _PerseveringFace)
    add(intArrayOf(0x1f629), _WearyFace)
    add(intArrayOf(0x1f62b), _TiredFace)
}

internal fun MutableList<Emoji>.addAllFaceConcerned() {
    add(_LoudlyCryingFace)
    add(_FaceHoldingBackTears)
    add(_PleadingFace)
    add(_YawningFace)
    add(_FaceScreamingInFear)
    add(_DisappointedFace)
    add(_DowncastFaceWithSweat)
    add(_WorriedFace)
    add(_SadButRelievedFace)
    add(_CryingFace)
    add(_FrowningFace)
    add(_SlightlyFrowningFace)
    add(_FaceWithDiagonalMouth)
    add(_ConfusedFace)
    add(_AnxiousFaceWithSweat)
    add(_FearfulFace)
    add(_AnguishedFace)
    add(_FrowningFaceWithOpenMouth)
    add(_FaceWithOpenMouth)
    add(_HushedFace)
    add(_AstonishedFace)
    add(_FlushedFace)
    add(_ConfoundedFace)
    add(_PerseveringFace)
    add(_WearyFace)
    add(_TiredFace)
}

/**
 * All Emoji of the Smileys & Emotion: face-concerned subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceConcerned(): List<Emoji> =
    ArrayList<Emoji>(26).apply { addAllFaceConcerned() }
