package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GreenSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟩",
        description = "green square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("green-square", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: green square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GreenSquare: Emoji get() = _GreenSquare
