package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteMediumSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "◻️",
        description = "white medium square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-medium-square", "white-square-medium"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: white medium square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteMediumSquare: Emoji get() = _WhiteMediumSquare

/**
 * Alias to emoji [WhiteMediumSquare] (Symbols: geometric: white medium square).
*/
public val Emoji.Companion.WhiteSquareMedium: Emoji get() = _WhiteMediumSquare
