package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TwoOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕑",
        description = "two o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("two-oclock", "two-o-clock"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: time: two o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TwoOclock: Emoji get() = _TwoOclock

/**
 * Alias to emoji [TwoOclock] (Travel & Places: time: two o’clock).
*/
public val Emoji.Companion.TwoOClock: Emoji get() = _TwoOclock
