package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseDolls: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎎",
        description = "Japanese dolls",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-dolls", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: event: Japanese dolls.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseDolls: Emoji get() = _JapaneseDolls
