package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Bullseye: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎯",
        description = "bullseye",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bullseye", "direct-hit", "target"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Activities: game: bullseye.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Bullseye: Emoji get() = _Bullseye

/**
 * Alias to emoji [Bullseye] (Activities: game: bullseye).
*/
public val Emoji.Companion.DirectHit: Emoji get() = _Bullseye

/**
 * Alias to emoji [Bullseye] (Activities: game: bullseye).
*/
public val Emoji.Companion.Target: Emoji get() = _Bullseye
