package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpadeSuit: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♠️",
        description = "spade suit",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("spade-suit", "spade"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: spade suit.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpadeSuit: Emoji get() = _SpadeSuit

/**
 * Alias to emoji [SpadeSuit] (Activities: game: spade suit).
*/
public val Emoji.Companion.Spade: Emoji get() = _SpadeSuit
