package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MartialArtsUniform: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥋",
        description = "martial arts uniform",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("martial-arts-uniform", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: sport: martial arts uniform.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MartialArtsUniform: Emoji get() = _MartialArtsUniform
