package org.kodein.emoji.animals_nature.animal_mammal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Horse: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐎",
        description = "horse",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("horse", "racehorse"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-mammal: horse.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Horse: Emoji get() = _Horse

/**
 * Alias to emoji [Horse] (Animals & Nature: animal-mammal: horse).
*/
public val Emoji.Companion.Racehorse: Emoji get() = _Horse
