package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCaribbeanNetherlands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇶",
        description = "flag: Caribbean Netherlands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-caribbean-netherlands", "caribbean-netherlands-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Caribbean Netherlands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCaribbeanNetherlands: Emoji get() = _FlagCaribbeanNetherlands

/**
 * Alias to emoji [FlagCaribbeanNetherlands] (Flags: country-flag: flag: Caribbean Netherlands).
*/
public val Emoji.Companion.CaribbeanNetherlandsFlag: Emoji get() = _FlagCaribbeanNetherlands
