package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCeutaMelilla: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇦",
        description = "flag: Ceuta & Melilla",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ceuta-melilla", "ceuta-melilla-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ceuta & Melilla.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCeutaMelilla: Emoji get() = _FlagCeutaMelilla

/**
 * Alias to emoji [FlagCeutaMelilla] (Flags: country-flag: flag: Ceuta & Melilla).
*/
public val Emoji.Companion.CeutaMelillaFlag: Emoji get() = _FlagCeutaMelilla
