package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUnitedStates: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇸",
        description = "flag: United States",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-united-states", "united-states-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.9f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: United States.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUnitedStates: Emoji get() = _FlagUnitedStates

/**
 * Alias to emoji [FlagUnitedStates] (Flags: country-flag: flag: United States).
*/
public val Emoji.Companion.UnitedStatesFlag: Emoji get() = _FlagUnitedStates
